<?php

namespace App\Http\Controllers;

use App\Models\Portofolio;
use Illuminate\Http\Request;

class PortofolioController extends Controller
{
    public function index()
    {
        $portofolio = Portofolio::all();

        $headers = ['Judul', 'Deskripsi', 'Aksi'];

        $rows = $portofolio->map(function ($p) {
            return [
                'cols' => [
                    $p->title,
                    $p->description,
                ],
                'actions' => view('components.action-button', ['id' => $p->id, 'resource' => 'portofolios'])->render(),
            ];
        });

        return view('portofolios.index', compact('headers', 'rows'));
    }

    public function create()
    {
        return view('portofolios.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'title'       => 'required|string|max:150',
            'description' => 'required|string',
            'image'       => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $filename = time() . '_' . $file->getClientOriginalName();

            $file->move(public_path('assets/img/contents'), $filename);

            $validated['image'] = 'assets/img/contents/' . $filename;
        }

        Portofolio::create($validated);

        return redirect()->route('portofolios.index')
            ->with('success', 'Portofolio berhasil ditambahkan');
    }

    public function show(Portofolio $portofolio)
    {
        return view('portofolios.show', compact('portofolio'));
    }

    public function edit(Portofolio $portofolio)
    {
        return view('portofolios.edit', compact('portofolio'));
    }

    public function update(Request $request, Portofolio $portofolio)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:150',
            'description' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'remove_image' => 'nullable|boolean'
        ]);

        if ($request->remove_image == 1) {
            if ($portofolio->image && file_exists(public_path($portofolio->image))) {
                unlink(public_path($portofolio->image));
            }
            $validated['image'] = null;
        }

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $filename = time() . '_' . $file->getClientOriginalName();
            $file->move(public_path('assets/img/contents'), $filename);

            if ($portofolio->image && file_exists(public_path($portofolio->image))) {
                unlink(public_path($portofolio->image));
            }

            $validated['image'] = 'assets/img/contents/' . $filename;
        }

        $portofolio->update($validated);

        return redirect()->route('portofolios.index')->with('success', 'Portofolio berhasil diperbarui');
    }

    public function destroy(Portofolio $portofolio)
    {
        if ($portofolio->image && file_exists(public_path($portofolio->image))) {
            unlink(public_path($portofolio->image));
        }

        $portofolio->delete();

        return redirect()->route('portofolios.index')
            ->with('success', 'Portofolio berhasil dihapus');
    }
}
