<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ResellerOrder extends Model
{
    protected $fillable = [
        'reseller_id',
        'order_date',
        'invoice_number',
        'total',
    ];

    protected $casts = [
        'order_date' => 'date', 
    ];

    public function reseller()
    {
        return $this->belongsTo(Reseller::class);
    }

    public function details()
    {
        return $this->hasMany(ResellerOrderDetail::class);
    }

    public function payments()
    {
        return $this->hasMany(ResellerPayment::class);
    }
}
