@props([
    'name',
    'label' => null,
    'inRowLabel' => null,
    'rows' => 3,
    'value' => old($name),
    'placeholder' => '',
    'required' => false,
    'disabled' => false,
    'class' => '',
])

<style>
    .textarea-theme {
        background: #f6e4bd !important;
        color: #661b18 !important;
        border: 1px solid #d4af37 !important;
        border-radius: 6px;
        padding: 10px 12px;
        font-size: 15px;
        resize: vertical;
    }

    .textarea-theme:focus {
        border-color: #c19d2f !important;
        box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.25) !important;
        outline: none !important;
    }

    .textarea-theme::placeholder {
        color: #8b5f5c;
    }

    .label-theme {
        color: #661b18;
        font-weight: 600;
        margin-bottom: 4px;
        display: inline-block;
    }

    .input-error {
        color: #b70000;
        font-size: 14px;
        margin-top: 4px;
    }
</style>

@if ($inRowLabel)
    <div class="row mb-3 align-items-start w-100">
        <label for="{{ $name }}" class="col-lg-2 col-form-label label-theme">
            {{ $inRowLabel }}
        </label>

        <div class="col-lg-10">
            <textarea
                name="{{ $name }}"
                id="{{ $name }}"
                rows="{{ $rows }}"
                placeholder="{{ $placeholder }}"
                @if ($required) required @endif
                @if ($disabled) disabled @endif
                class="form-control textarea-theme {{ $class }}"
                {{ $attributes }}
            >{{ $value }}</textarea>

            @error($name)
                <div class="input-error">{{ $message }}</div>
            @enderror
        </div>
    </div>

@else
    <div class="mb-3 w-100">
        @if ($label)
            <label for="{{ $name }}" class="label-theme">
                {{ $label }}
            </label>
        @endif

        <textarea
            name="{{ $name }}"
            id="{{ $name }}"
            rows="{{ $rows }}"
            placeholder="{{ $placeholder }}"
            @if ($required) required @endif
            @if ($disabled) disabled @endif
            class="form-control textarea-theme {{ $class }}"
            {{ $attributes }}
        >{{ $value }}</textarea>

        @error($name)
            <div class="input-error">{{ $message }}</div>
        @enderror
    </div>
@endif
