@extends('layout.main')
@section('title', 'Dashboard')
@section('content')

<div class="container">

    <div class="row g-3">

        {{-- User (hanya owner) --}}
        @if(auth()->user()->role === 'owner')
        <div class="col-md-3 col-sm-6">
            <a href="{{ route('users.index') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-people fs-1"></i>
                        <h5 class="card-title mt-2">User</h5>
                    </div>
                </div>
            </a>
        </div>
        @endif

        {{-- Portofolio --}}
        <div class="col-md-3 col-sm-6">
            <a href="{{ route('portofolios.index') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-images fs-1"></i>
                        <h5 class="card-title mt-2">Portofolio</h5>
                    </div>
                </div>
            </a>
        </div>

        {{-- Laporan Mingguan --}}
        <div class="col-md-3 col-sm-6">
            <a href="{{ route('reports.index') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-bar-chart fs-1"></i>
                        <h5 class="card-title mt-2">Laporan Mingguan</h5>
                    </div>
                </div>
            </a>
        </div>

        {{-- Laporan Bulanan --}}
        <div class="col-md-3 col-sm-6">
            <a href="{{ route('reports.monthly') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-calendar-month fs-1"></i>
                        <h5 class="card-title mt-2">Laporan Bulanan</h5>
                    </div>
                </div>
            </a>
        </div>

        {{-- Daftar Produk --}}
        <div class="col-md-3 col-sm-6">
            <a href="{{ route('products.index') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-box-seam fs-1"></i>
                        <h5 class="card-title mt-2">Daftar Produk</h5>
                    </div>
                </div>
            </a>
        </div>

        {{-- Produksi Barang --}}
        <div class="col-md-3 col-sm-6">
            <a href="{{ route('productions.index') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-clipboard-plus fs-1"></i>
                        <h5 class="card-title mt-2">Produksi Barang</h5>
                    </div>
                </div>
            </a>
        </div>

        {{-- Customer Orders --}}
        <div class="col-md-3 col-sm-6">
            <a href="{{ route('orders.index') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-bag-check fs-1"></i>
                        <h5 class="card-title mt-2">Customer Orders</h5>
                    </div>
                </div>
            </a>
        </div>

        {{-- Reseller Sections --}}
        <div class="col-md-3 col-sm-6">
            <a href="{{ route('resellers.index') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-people fs-1"></i>
                        <h5 class="card-title mt-2">Daftar Reseller</h5>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3 col-sm-6">
            <a href="{{ route('reseller-orders.index') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-bag-check fs-1"></i>
                        <h5 class="card-title mt-2">Order Reseller</h5>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3 col-sm-6">
            <a href="{{ route('reseller-stocks.index') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-boxes fs-1"></i>
                        <h5 class="card-title mt-2">Stok Reseller</h5>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3 col-sm-6">
            <a href="{{ route('reseller-payments.index') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-cash-coin fs-1"></i>
                        <h5 class="card-title mt-2">Pembayaran Reseller</h5>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3 col-sm-6">
            <a href="{{ route('reseller-barters.index') }}" class="text-decoration-none">
                <div class="card text-center shadow-sm dashboard-card">
                    <div class="card-body">
                        <i class="bi bi-arrow-left-right fs-1"></i>
                        <h5 class="card-title mt-2">Barter Reseller</h5>
                    </div>
                </div>
            </a>
        </div>

    </div>
</div>

<style>
.dashboard-card {
    border: 1px solid #d4af37 !important;
    color: #661b18 !important;
    transition: transform 0.2s, box-shadow 0.2s;
}

.dashboard-card .card-body {
    color: #661b18 !important;
}

.dashboard-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 15px rgba(0,0,0,0.2);
}

.dashboard-card i {
    color: #661b18 !important;
}

.dashboard-card .card-title {
    color: #661b18 !important;
    font-weight: 600;
}
</style>


@endsection
