@extends('layout.main')
@section('title', 'Detail Portofolio')
@section('content')

<div class="container">

    <div class="d-flex justify-content-between align-items-start flex-lg-row flex-column">

        <div class="text-center p-4 pt-0 d-flex flex-column">
            <div class="upload-box">
                @if($portofolio->image)
                    <img class="preview-img" src="{{ asset($portofolio->image) }}" alt="portofolio image">
                @else
                    <div style="padding-top:30px">Tidak Ada Gambar</div>
                @endif
            </div>
        </div>

        <div class="w-100">

            <div class="mb-3">
                <label class="field-label">Judul</label>
                <input type="text" class="form-control field-value" value="{{ $portofolio->title }}" disabled>
            </div>

            <div class="mb-3">
                <label class="field-label">Deskripsi</label>
                <textarea class="form-control field-value" rows="4" disabled>{{ $portofolio->description }}</textarea>
            </div>

            <div class="d-flex justify-content-between pe-2 mt-4">
                <x-gold-button onclick="window.location.href='{{ route('portofolios.index') }}'">
                    <i class="bi bi-arrow-left"></i> Kembali
                </x-gold-button>

                <x-button onclick="window.location.href='{{ route('portofolios.edit', $portofolio->id) }}'">
                    Edit Portofolio
                </x-button>
            </div>

            <div class="text-muted small mt-3">
                Dibuat: {{ $portofolio->created_at?->format('Y-m-d H:i') ?? '-' }}
                &nbsp;|&nbsp;
                Diperbarui: {{ $portofolio->updated_at?->format('Y-m-d H:i') ?? '-' }}
            </div>

        </div>

    </div>
</div>

@endsection
