@extends('layout.main') 
@section('title', 'Edit Produksi') 
@section('content')

<div class="container">
    <form method="POST" action="{{ route('productions.update', $production->id) }}">
        @csrf
        @method('PUT')

        <div class="d-flex justify-content-between align-items-start flex-lg-column flex-column">

            <div class="w-100">

                <x-input-text
                    inRowLabel="Tanggal Produksi"
                    name="production_date"
                    type="date"
                    required
                    :value="old('production_date', $production->production_date->format('Y-m-d'))"
                    :errorMessage="$errors->first('production_date')"
                />

                <x-input-text
                    inRowLabel="Biaya Bahan (Rp)"
                    name="cost_material"
                    required
                    placeholder="Masukkan biaya bahan"
                    :value="old('cost_material', $production->cost_material)"
                    :errorMessage="$errors->first('cost_material')"
                />

                <x-input-text
                    inRowLabel="Biaya Operasional (Rp)"
                    name="operational_cost"
                    required
                    placeholder="Masukkan biaya operasional"
                    :value="old('operational_cost', $production->operational_cost)"
                    :errorMessage="$errors->first('operational_cost')"
                />

                <x-input-text-area
                    inRowLabel="Catatan"
                    name="notes"
                    rows="3"
                    placeholder="Masukkan catatan tambahan (opsional)"
                    :value="old('notes', $production->notes)"
                    :errorMessage="$errors->first('notes')"
                />

                <h5 class="mt-4">Jumlah Produksi per Produk</h5>
                <p class="text-muted">Isi 0 jika tidak diproduksi</p>

                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Produk</th>
                                <th>Jumlah Produksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($products as $product)
                                @php
                                    $detail = $production->details->firstWhere('product_id', $product->id);
                                    $quantity = $detail ? $detail->quantity : 0;
                                @endphp
                                <tr>
                                    <td>{{ $product->name }}</td>
                                    <td>
                                        <input type="number" 
                                               name="products[{{ $loop->index }}][quantity]" 
                                               min="0" 
                                               class="form-control"
                                               value="{{ old('products.' . $loop->index . '.quantity', $quantity) }}">
                                        <input type="hidden" name="products[{{ $loop->index }}][product_id]" value="{{ $product->id }}">
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-flex justify-content-between pe-2 mt-4">
                    <x-gold-button type="button" onclick="window.location.href='{{ route('productions.index') }}'">
                        <i class="bi bi-arrow-left"></i> Kembali
                    </x-gold-button>

                    <x-button type="submit">
                        Update Produksi
                    </x-button>
                </div>

            </div>

        </div>
    </form>
</div>

@endsection
