@extends('layout.main') 
@section('title', 'Edit Produk') 
@section('content')

<div class="container">
    <form method="POST" action="{{ route('products.update', $product->id) }}" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <input type="hidden" name="remove_image" id="remove_image" value="0">

        <div class="d-flex justify-content-between align-items-start flex-lg-row flex-column">

            <div class="text-center p-4 pt-0 d-flex flex-column">
                <label for="image" class="upload-box d-flex flex-column align-items-center justify-content-center" style="min-height:220px;">
                    <div id="image-preview" class="d-flex align-items-center justify-content-center w-100 h-100">
                        @if($product->image)
                            <img id="preview-img" src="{{ asset($product->image) }}" style="display:block; max-width:200px;">
                            <div id="image-instruction" class="text-muted" style="display:none;">Upload Foto</div>
                        @else
                            <div id="image-instruction" class="text-muted">Upload Foto</div>
                        @endif
                    </div>

                    <img id="preview-img-new" src="#" style="display:none; max-width:200px;">
                    <div id="file-name-new"></div>
                </label>

                <input 
                    type="file" 
                    name="image" 
                    id="image" 
                    class="d-none" 
                    accept="image/*"
                    onchange="previewImage(event)"
                >

                <button type="button" id="remove-image-btn"
                    class="btn btn-outline-danger remove-btn mt-2"
                    style="{{ $product->image ? 'display:inline-block;' : 'display:none;' }}"
                    onclick="removeImage()"
                >
                    Remove File
                </button>
            </div>

            <div class="w-100">

                <x-input-text
                    inRowLabel="Nama Produk"
                    name="name"
                    required
                    placeholder="Masukkan nama produk"
                    :value="old('name', $product->name)"
                    :errorMessage="$errors->first('name')"
                />

                <x-input-text
                    inRowLabel="Harga"
                    name="price"
                    required
                    placeholder="Masukkan harga produk"
                    :value="old('price', $product->price)"
                    :errorMessage="$errors->first('price')"
                />

                <x-input-select
                    inRowLabel="Tersedia untuk Reseller"
                    name="available_for_reseller"
                    id="available_for_reseller"
                    :options="['0' => 'Tidak', '1' => 'Ya']"
                    :value="old('available_for_reseller', $product->available_for_reseller)"
                />

                <x-input-text
                    inRowLabel="Harga Reseller"
                    name="reseller_price"
                    id="reseller_price"
                    placeholder="Masukkan harga reseller"
                    :value="old('reseller_price', $product->reseller_price)"
                    :errorMessage="$errors->first('reseller_price')"
                />

                <x-input-text-area
                    label="Deskripsi"
                    name="description"
                    rows="3"
                    required
                    placeholder="Masukkan deskripsi produk"
                    :value="old('description', $product->description)"
                    :errorMessage="$errors->first('description')"
                />

                <div class="d-flex justify-content-between pe-2 mt-4">
                    <x-gold-button type="button" onclick="window.location.href='{{ route('products.index') }}'">
                        <i class="bi bi-arrow-left"></i> Back
                    </x-gold-button>

                    <x-button type="submit">
                        Update Product
                    </x-button>
                </div>

            </div>
        </div>
    </form>
</div>

<script>
function previewImage(event) {
    const input = event.target;
    const previewNew = document.getElementById('preview-img-new');
    const previewOld = document.getElementById('preview-img');
    const instruction = document.getElementById('image-instruction');
    const removeBtn = document.getElementById('remove-image-btn');
    const removeFlag = document.getElementById('remove_image');

    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = e => {
            previewNew.src = e.target.result;
            previewNew.style.display = 'block';
        };
        reader.readAsDataURL(input.files[0]);

        if (previewOld) previewOld.style.display = 'none';
        instruction.style.display = 'none';
        removeBtn.style.display = 'inline-block';
        removeFlag.value = 0;
    }
}

function removeImage() {
    const input = document.getElementById('image');
    const previewOld = document.getElementById('preview-img');
    const previewNew = document.getElementById('preview-img-new');
    const instruction = document.getElementById('image-instruction');
    const removeBtn = document.getElementById('remove-image-btn');
    const removeFlag = document.getElementById('remove_image');

    input.value = "";
    if (previewOld) previewOld.style.display = 'none';
    previewNew.style.display = 'none';
    instruction.style.display = 'block';
    removeBtn.style.display = 'none';
    removeFlag.value = 1;
}
</script>

@endsection
