@extends('layout.main')
@section('title', 'Profile Owner')
@section('content')

<style>
    .field-label {
        font-weight: 600;
        font-size: .95rem;
        color: #661b18;
    }

    .field-value {
        background: #f6e4bd !important;
        color: #661b18 !important;
        border: 1px solid #d4af37 !important;
        border-radius: 6px;
        padding: 8px 12px;
        font-size: 15px;
    }

    .maps-frame {
        border-radius: 8px;
        border: 1px solid #d4af37;
        overflow: hidden;
        width: 100%;
    }

    .maps-frame iframe {
        width: 100% !important;
        height: 400px !important;
        border: 0;
        display: block;
    }
</style>

<div class="container">

    <div class="mb-3">
        <label class="field-label">Nama</label>
        <input type="text" class="form-control field-value" value="{{ $user->name }}" disabled>
    </div>

    <div class="mb-3">
        <label class="field-label">Email</label>
        <input type="text" class="form-control field-value" value="{{ $user->email }}" disabled>
    </div>

    <div class="mb-3">
        <label class="field-label">Nomor Telepon</label>
        <input type="text" class="form-control field-value" value="{{ $user->phone ?? '-' }}" disabled>
    </div>

    <div class="mb-3">
        <label class="field-label">Alamat</label>
        <textarea class="form-control field-value" rows="3" disabled>{{ $profile->address ?? '-' }}</textarea>
    </div>

    <div class="mb-3">
        <label class="field-label">Instagram</label>
        <input type="text" class="form-control field-value" value="{{ $profile->instagram ?? '-' }}" disabled>
    </div>

    <div class="mb-3">
        <label class="field-label">Shopee</label>
        <input type="text" class="form-control field-value" value="{{ $profile->shopee ?? '-' }}" disabled>
    </div>

    <div class="mb-3">
        <label class="field-label">Tokopedia</label>
        <input type="text" class="form-control field-value" value="{{ $profile->tokopedia ?? '-' }}" disabled>
    </div>

    <div class="mb-3">
        <label class="field-label">Lokasi</label>

        @if(!empty($profile->maps))
            <div class="maps-frame">
                {!! $profile->maps !!}
            </div>
        @else
            <div class="form-control field-value" disabled>-</div>
        @endif
    </div>

    <div class="d-flex justify-content-between pe-2 mt-4">
        <x-gold-button type="button" onclick="window.location.href='{{ route('dashboard') }}'">
            <i class="bi bi-arrow-left"></i> Kembali
        </x-gold-button>

        <x-button type="button" onclick="window.location.href='{{ route('profile.edit') }}'">
            Edit Profile
        </x-button>
    </div>

    <div class="text-muted small mt-3">
        Dibuat: {{ $profile?->created_at?->format('Y-m-d H:i') ?? '-' }}
        &nbsp;|&nbsp;
        Diperbarui: {{ $profile?->updated_at?->format('Y-m-d H:i') ?? '-' }}
    </div>

</div>

@endsection