@extends('layout.main')
@section('title', 'Laporan Mingguan')

@section('content')

<div class="row mb-3">
    <div class="col-md-12">
        <form method="GET" action="{{ route('reports.index') }}" class="row g-3 align-items-end">

            <div class="col-md-4">
                <label class="form-label">Dari Tanggal</label>

                <input 
                    type="text"
                    class="form-control date-display"
                    placeholder="dd/mm/yyyy"
                    value="{{ \Carbon\Carbon::parse($startDate)->format('d/m/Y') }}"
                >

                <input 
                    type="hidden"
                    name="start_date"
                    class="date-hidden"
                    value="{{ $startDate }}"
                >
            </div>

            <div class="col-md-4">
                <label class="form-label">Sampai Tanggal</label>

                <input 
                    type="text"
                    class="form-control date-display"
                    placeholder="dd/mm/yyyy"
                    value="{{ \Carbon\Carbon::parse($endDate)->format('d/m/Y') }}"
                >

                <input 
                    type="hidden"
                    name="end_date"
                    class="date-hidden"
                    value="{{ $endDate }}"
                >
            </div>

            <div class="col-md-4">
                <x-button type="submit">Filter</x-button>
            </div>

        </form>
    </div>
</div>

@php
$headers = [
    'Tanggal Awal',
    'Tanggal Akhir',
    'Total Penjualan',
    'Total Reseller',
    'Total Barter',
    'Biaya Bahan',
    'Biaya Operasional',
    'Total Biaya',
    'Laba Bersih'
];
@endphp

<div class="table-responsive">
<table class="table table-bordered table-striped">
    <thead>
        <tr>
            @foreach ($headers as $header)
                <th>{{ $header }}</th>
            @endforeach
        </tr>
    </thead>

    <tbody>
        @forelse ($weeks as $w)
        <tr>
            <td>{{ $w['tanggal_awal'] }}</td>
            <td>{{ $w['tanggal_akhir'] }}</td>
            <td>Rp {{ number_format($w['total_penjualan'],0,',','.') }}</td>
            <td>Rp {{ number_format($w['total_reseller'],0,',','.') }}</td>
            <td>Rp {{ number_format($w['total_barter'],0,',','.') }}</td>
            <td>Rp {{ number_format($w['biaya_bahan'],0,',','.') }}</td>
            <td>Rp {{ number_format($w['biaya_operasional'],0,',','.') }}</td>
            <td>Rp {{ number_format($w['total_biaya'],0,',','.') }}</td>
            <td>Rp {{ number_format($w['laba_bersih'],0,',','.') }}</td>
        </tr>
        @empty
        <tr>
            <td colspan="9" class="text-center text-muted py-3">
                No data available.
            </td>
        </tr>
        @endforelse
    </tbody>
</table>
</div>

@endsection
