@extends('layout.main')
@section('title', 'Reseller Barter - '.$reseller->name)
@section('content')

<div class="row mb-3">
    <div class="col-md-12 d-flex justify-content-start">
        <x-button href="{{ route('reseller-barters.create', ['reseller' => $reseller->id]) }}">
            Tambah Barter
        </x-button>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-12">
        <form method="GET" action="{{ route('reseller-barters.show', $reseller->id) }}" class="row g-3">

            <div class="col-md-4">
                <label>Dari Tanggal</label>
                <input type="date" name="start_date" class="form-control"
                    value="{{ request('start_date', $startDate) }}">
            </div>

            <div class="col-md-4">
                <label>Sampai Tanggal</label>
                <input type="date" name="end_date" class="form-control"
                    value="{{ request('end_date', $endDate) }}">
            </div>

            <div class="col-md-4 d-flex align-items-end">
                <x-button type="submit">
                    Filter
                </x-button>
            </div>

        </form>
    </div>
</div>

<x-table :headers="$headers" :rows="$tableRows" />

<div class="mt-4">
    <x-gold-button type="button" onclick="window.location.href='{{ route('reseller-barters.index') }}'">
        <i class="bi bi-arrow-left"></i> Kembali
    </x-gold-button>
</div>

@endsection
