@extends('layout.main')
@section('title', 'Edit Pesanan Reseller')
@section('content')

<div class="container">
    <form method="POST" action="{{ route('reseller-orders.update', $resellerOrder->id) }}">
        @csrf
        @method('PUT')

        <x-input-select
            inRowLabel="Reseller"
            name="reseller_id"
            :options="$resellers->pluck('name','id')->toArray()"
            :value="old('reseller_id', $resellerOrder->reseller_id)"
            required
        />

        <x-input-text
            inRowLabel="No. Nota"
            name="invoice_number"
            placeholder="Masukkan No. Nota (opsional)"
            :value="old('invoice_number', $resellerOrder->invoice_number)"
        />

        <x-input-text
            inRowLabel="Tanggal Order"
            name="order_date"
            type="date"
            required
            :value="old('order_date', $resellerOrder->order_date?->format('Y-m-d'))"
        />

        <h5 class="mt-4">Products</h5>
        <p class="text-muted">Isi 0 jika tidak dipesan</p>

        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Produk</th>
                        <th>Jumlah</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($products as $product)
                        @php
                            $detail = $resellerOrder->details->firstWhere('product_id', $product->id) ?? null;
                        @endphp
                        <tr>
                            <td>{{ $product->name }} (Rp {{ number_format($product->reseller_price ?? $product->price,0,',','.') }})</td>
                            <td>
                                <input type="number"
                                       name="products[{{ $product->id }}][qty]"
                                       min="0"
                                       class="form-control"
                                       value="{{ old('products.'.$product->id.'.qty', $detail->qty ?? 0) }}">
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-between mt-4">
            <x-gold-button type="button" onclick="window.location.href='{{ route('reseller-orders.index') }}'">
                <i class="bi bi-arrow-left"></i> Kembali
            </x-gold-button>

            <x-button type="submit">
                Simpan
            </x-button>
        </div>
    </form>
</div>

@endsection
