@extends('layout.main')
@section('title', 'Detail Pesanan Reseller')
@section('content')

<div class="container">
    <div class="mb-3">
        <strong>Reseller:</strong> {{ $resellerOrder->reseller->name ?? '-' }}
    </div>
    <div class="mb-3">
        <strong>Tanggal Order:</strong> {{ $resellerOrder->order_date->format('d F Y') }}
    </div>
    <div class="mb-3">
        <strong>No. Nota:</strong> {{ $resellerOrder->invoice_number ?? '-' }}
    </div>
    <div class="mb-3">
        <strong>Total:</strong> Rp {{ number_format($resellerOrder->total,0,',','.') }}
    </div>

    <h5>Produk</h5>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Nama Produk</th>
                <th>Jumlah</th>
                <th>Harga</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @forelse($resellerOrder->details as $detail)
                <tr>
                    <td>{{ $detail->product->name }}</td>
                    <td>{{ $detail->qty }}</td>
                    <td>Rp {{ number_format($detail->price, 0, ',', '.') }}</td>
                    <td>Rp {{ number_format($detail->qty * $detail->price, 0, ',', '.') }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="text-center">Tidak ada produk</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <x-gold-button type="button" onclick="window.location.href='{{ route('reseller-orders.index') }}'">
        <i class="bi bi-arrow-left"></i> Kembali
    </x-gold-button>
</div>

@endsection
