@extends('layout.main')
@section('title', 'Tambah Pembayaran')
@section('content')

<div class="container">
    <form method="POST" action="{{ route('reseller-payments.store') }}" enctype="multipart/form-data">
        @csrf

        <x-input-select
            inRowLabel="Reseller"
            name="reseller_id"
            :options="$resellers->pluck('name','id')"
            :value="old('reseller_id')"
        />

        <x-input-text
            inRowLabel="Jumlah Bayar"
            name="amount_paid"
            required
            placeholder="Masukkan jumlah pembayaran"
            :value="old('amount_paid')"
            :errorMessage="$errors->first('amount_paid')"
        />

        <x-input-text
            inRowLabel="Tanggal Pembayaran"
            name="payment_date"
            type="date"
            required
            :value="old('payment_date', date('Y-m-d'))"
            :errorMessage="$errors->first('payment_date')"
        />

        <x-input-file
            inRowLabel="Bukti Pembayaran"
            name="proof"
            :errorMessage="$errors->first('proof')"
        />

        <div class="d-flex justify-content-between mt-4">
            <x-gold-button type="button" onclick="window.location.href='{{ route('reseller-payments.index') }}'">
                <i class="bi bi-arrow-left"></i> Kembali
            </x-gold-button>

            <x-button type="submit">
                Simpan
            </x-button>
        </div>

    </form>
</div>

@endsection
