
<?php $__env->startSection('title', 'Detail Pembayaran Reseller'); ?>
<?php $__env->startSection('content'); ?>

<div class="container">
    <div class="mb-3">
        <label class="form-label">Reseller</label>
        <input type="text" class="form-control" 
            value="<?php echo e($resellerPayment->reseller->name ?? '-'); ?>" disabled>
    </div>

    <div class="mb-3">
        <label class="form-label">Tanggal Pesanan</label>
        <input type="text" class="form-control" 
            value="<?php echo e(optional($resellerPayment->resellerOrder->order_date)->format('d F Y') ?? '-'); ?>" disabled>
    </div>

    <div class="mb-3">
        <label class="form-label">No. Nota</label>
        <input type="text" class="form-control" 
            value="<?php echo e($resellerPayment->resellerOrder->invoice_number ?? '-'); ?>" disabled>
    </div>

    <div class="row mb-3">
        <div class="col-md-4">
            <label class="form-label">Total Tagihan</label>
            <input type="text" class="form-control"
                value="Rp <?php echo e(number_format($resellerPayment->amount_due, 0, ',', '.')); ?>" disabled>
        </div>

        <div class="col-md-4">
            <label class="form-label">Terbayar</label>
            <input type="text" class="form-control"
                value="Rp <?php echo e(number_format($resellerPayment->amount_paid, 0, ',', '.')); ?>" disabled>
        </div>

        <div class="col-md-4">
            <label class="form-label">Sisa</label>
            <input type="text" class="form-control"
                value="Rp <?php echo e(number_format($resellerPayment->amount_due - $resellerPayment->amount_paid, 0, ',', '.')); ?>" disabled>
        </div>
    </div>

    <div class="mb-3">
        <label class="form-label">Status</label>
        <input type="text" class="form-control" 
            value="<?php echo e(ucfirst($resellerPayment->status)); ?>" disabled>
    </div>

    <h5 class="mt-4">History Pembayaran</h5>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Tanggal</th>
                <th>Jumlah</th>
                <th width="120">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $resellerPayment->histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($history->payment_date->format('d F Y')); ?></td>
                    <td>Rp <?php echo e(number_format($history->amount, 0, ',', '.')); ?></td>
                    <td>
                        <form 
                            action="<?php echo e(route('reseller-payment-histories.destroy', $history->id)); ?>" 
                            method="POST"
                            onsubmit="return confirm('Yakin ingin menghapus history pembayaran ini?')"
                        >
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>

                            <button type="submit" class="btn px-2 py-1" style="background-color:#8c2b25;color:#ffffff;border-radius:6px;">
                                <i class="bi bi-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="3" class="text-center">Belum ada pembayaran</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>


    <div class="d-flex justify-content-start mt-4">
        <?php if (isset($component)) { $__componentOriginalb04da7a8feb93a7268b6e0eef6b32739 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb04da7a8feb93a7268b6e0eef6b32739 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.gold-button','data' => ['type' => 'button','onclick' => 'window.location.href=\''.e(route('reseller-payments.index')).'\'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('gold-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'button','onclick' => 'window.location.href=\''.e(route('reseller-payments.index')).'\'']); ?>
            <i class="bi bi-arrow-left"></i> Kembali
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb04da7a8feb93a7268b6e0eef6b32739)): ?>
<?php $attributes = $__attributesOriginalb04da7a8feb93a7268b6e0eef6b32739; ?>
<?php unset($__attributesOriginalb04da7a8feb93a7268b6e0eef6b32739); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb04da7a8feb93a7268b6e0eef6b32739)): ?>
<?php $component = $__componentOriginalb04da7a8feb93a7268b6e0eef6b32739; ?>
<?php unset($__componentOriginalb04da7a8feb93a7268b6e0eef6b32739); ?>
<?php endif; ?>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\PAW\PiaZhang\resources\views/reseller_payments/show.blade.php ENDPATH**/ ?>